-- phpMyAdmin SQL Dump
-- version 5.2.0
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Generation Time: Jul 15, 2023 at 01:18 PM
-- Server version: 10.4.24-MariaDB
-- PHP Version: 7.4.29

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `live_stock`
--

-- --------------------------------------------------------

--
-- Table structure for table `client`
--

CREATE TABLE `client` (
  `c_id` int(11) NOT NULL,
  `c_ct_id` int(11) NOT NULL,
  `c_name` varchar(255) NOT NULL,
  `c_email` varchar(255) NOT NULL,
  `c_address` varchar(500) NOT NULL,
  `c_phone` varchar(255) NOT NULL,
  `c_description` varchar(500) NOT NULL,
  `c_img_url` varchar(255) NOT NULL,
  `c_status` int(11) NOT NULL,
  `c_created_by` int(11) NOT NULL,
  `c_created_at` datetime NOT NULL,
  `c_updated_by` int(11) NOT NULL,
  `c_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `client_payment`
--

CREATE TABLE `client_payment` (
  `cp_id` int(11) NOT NULL,
  `cp_c_id` int(11) NOT NULL,
  `cp_prss_id` int(11) NOT NULL,
  `cp_lsss_id` int(11) NOT NULL,
  `cp_received_amount` double NOT NULL,
  `cp_paid_by` varchar(255) NOT NULL,
  `cp_cheque_no` varchar(255) NOT NULL,
  `cp_reference` varchar(255) NOT NULL,
  `cp_date` date NOT NULL,
  `cp_description` varchar(255) NOT NULL,
  `cp_status` int(11) NOT NULL,
  `cp_sale_type` int(11) NOT NULL COMMENT '1 = livestock sale\r\n2 = product sale payment',
  `cp_created_by` int(11) NOT NULL,
  `cp_created_at` datetime NOT NULL,
  `cp_updated_by` int(11) NOT NULL,
  `cp_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `client_type`
--

CREATE TABLE `client_type` (
  `ct_id` int(11) NOT NULL,
  `ct_name` varchar(255) NOT NULL,
  `ct_description` varchar(500) NOT NULL,
  `ct_status` int(11) NOT NULL,
  `ct_created_by` int(11) NOT NULL,
  `ct_created_at` datetime NOT NULL,
  `ct_updated_by` int(11) NOT NULL,
  `ct_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `expense`
--

CREATE TABLE `expense` (
  `ex_id` int(11) NOT NULL,
  `ex_expense_id` varchar(255) NOT NULL,
  `ex_name` varchar(255) NOT NULL,
  `ex_amount` double NOT NULL,
  `ex_exc_id` int(11) NOT NULL,
  `ex_exsc_id` int(11) NOT NULL,
  `ex_date` date NOT NULL,
  `ex_description` varchar(500) NOT NULL,
  `ex_status` int(11) NOT NULL,
  `ex_created_by` int(11) NOT NULL,
  `ex_created_at` datetime NOT NULL,
  `ex_updated_by` int(11) NOT NULL,
  `ex_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `expense_category`
--

CREATE TABLE `expense_category` (
  `exc_id` int(11) NOT NULL,
  `exc_name` varchar(255) NOT NULL,
  `exc_description` varchar(500) NOT NULL,
  `exc_status` int(11) NOT NULL,
  `exc_created_by` int(11) NOT NULL,
  `exc_created_at` datetime NOT NULL,
  `exc_updated_by` int(11) NOT NULL,
  `exc_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `expense_payment`
--

CREATE TABLE `expense_payment` (
  `exp_id` int(11) NOT NULL,
  `exp_ex_id` int(11) NOT NULL,
  `exp_paid_amount` double NOT NULL,
  `exp_paid_by` varchar(255) NOT NULL,
  `exp_cheque_no` varchar(255) NOT NULL,
  `exp_date` date NOT NULL,
  `exp_description` varchar(255) NOT NULL,
  `exp_status` int(11) NOT NULL,
  `exp_created_by` int(11) NOT NULL,
  `exp_created_at` datetime NOT NULL,
  `exp_updated_by` int(11) NOT NULL,
  `exp_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `expense_subcategory`
--

CREATE TABLE `expense_subcategory` (
  `exsc_id` int(11) NOT NULL,
  `exsc_name` varchar(255) NOT NULL,
  `exsc_exc_id` int(11) NOT NULL,
  `exsc_description` varchar(500) NOT NULL,
  `exsc_status` int(11) NOT NULL,
  `exsc_created_by` int(11) NOT NULL,
  `exsc_created_at` datetime NOT NULL,
  `exsc_updated_by` int(11) NOT NULL,
  `exsc_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `food_distributed_summary`
--

CREATE TABLE `food_distributed_summary` (
  `fdds_id` int(11) NOT NULL,
  `fdds_fd_id` int(11) NOT NULL,
  `fdds_date` date NOT NULL,
  `fdds_total` double NOT NULL,
  `fdds_status` int(11) NOT NULL,
  `fdds_created_by` int(11) NOT NULL,
  `fdds_created_at` datetime NOT NULL,
  `fdds_updated_by` int(11) NOT NULL,
  `fdds_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `food_distributed_value`
--

CREATE TABLE `food_distributed_value` (
  `fddv_id` int(11) NOT NULL,
  `fddv_fdds_id` int(11) NOT NULL,
  `fddv_shed_id` int(11) NOT NULL,
  `fddv_batch_id` int(11) NOT NULL,
  `fddv_need_quantity` double NOT NULL,
  `fddv_distributed_quantity` double NOT NULL,
  `fddv_description` varchar(255) DEFAULT NULL,
  `fddv_status` int(11) NOT NULL,
  `fddv_created_by` int(11) NOT NULL,
  `fddv_created_at` datetime NOT NULL,
  `fddv_updated_by` int(11) NOT NULL,
  `fddv_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `food_purchase_summary`
--

CREATE TABLE `food_purchase_summary` (
  `fdps_id` int(11) NOT NULL,
  `fdps_s_id` int(11) NOT NULL,
  `fdps_date` date NOT NULL,
  `fdps_sub_total` double NOT NULL,
  `fdps_grand_discount` double NOT NULL,
  `fdps_grand_total` double NOT NULL,
  `fdps_description` varchar(500) NOT NULL,
  `fdps_status` int(11) NOT NULL,
  `fdps_created_by` int(11) NOT NULL,
  `fdps_created_at` datetime NOT NULL,
  `fdps_updated_by` int(11) NOT NULL,
  `fdps_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `food_purchase_value`
--

CREATE TABLE `food_purchase_value` (
  `fdpv_id` int(11) NOT NULL,
  `fdpv_fdps_id` int(11) NOT NULL,
  `fdpv_fd_id` int(11) NOT NULL,
  `fdpv_unit_price` double NOT NULL,
  `fdpv_quantity` double NOT NULL,
  `fdpv_discount` double NOT NULL,
  `fdpv_total` double NOT NULL,
  `fdpv_status` int(11) NOT NULL,
  `fdpv_created_by` int(11) NOT NULL,
  `fdpv_created_at` datetime NOT NULL,
  `fdpv_updated_by` int(11) NOT NULL,
  `fdpv_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `food_summary`
--

CREATE TABLE `food_summary` (
  `fds_id` int(11) NOT NULL,
  `fds_food_title` varchar(255) NOT NULL,
  `fds_description` varchar(255) NOT NULL,
  `fds_unit_id` int(11) NOT NULL,
  `fds_status` int(11) NOT NULL,
  `fds_created_by` int(11) NOT NULL,
  `fds_created_at` datetime NOT NULL,
  `fds_updated_by` int(11) NOT NULL,
  `fds_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `food_value`
--

CREATE TABLE `food_value` (
  `fdv_id` int(11) NOT NULL,
  `fdv_fds_id` int(11) NOT NULL,
  `fdv_weight` double NOT NULL,
  `fdv_assigned_shed_id` int(11) NOT NULL,
  `fdv_assigned_batch_id` int(11) NOT NULL,
  `fdv_description` varchar(255) NOT NULL,
  `fdv_status` int(11) NOT NULL,
  `fdv_created_by` int(11) NOT NULL,
  `fdv_created_at` datetime NOT NULL,
  `fdv_updated_by` int(11) NOT NULL,
  `fdv_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `food_wasted`
--

CREATE TABLE `food_wasted` (
  `fdw_id` int(11) NOT NULL,
  `fdw_fd_id` int(11) NOT NULL,
  `fdw_quantity` double NOT NULL,
  `fdw_description` varchar(500) NOT NULL,
  `fdw_status` int(11) NOT NULL,
  `fdw_created_by` int(11) NOT NULL,
  `fdw_created_at` datetime NOT NULL,
  `fdw_updated_by` int(11) NOT NULL,
  `fdw_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `groups`
--

CREATE TABLE `groups` (
  `id` mediumint(8) UNSIGNED NOT NULL,
  `name` varchar(20) NOT NULL,
  `description` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `groups`
--

INSERT INTO `groups` (`id`, `name`, `description`) VALUES
(1, 'admin', 'Administrator'),
(2, 'members', 'General User'),
(4, 'driver', 'driver'),
(5, 'Client', '');

-- --------------------------------------------------------

--
-- Table structure for table `livestock`
--

CREATE TABLE `livestock` (
  `ls_id` int(11) NOT NULL,
  `ls_lst_type_id` int(11) NOT NULL,
  `ls_name` varchar(500) NOT NULL,
  `ls_description` varchar(1000) NOT NULL,
  `ls_status` int(11) NOT NULL,
  `ls_created_by` int(11) NOT NULL,
  `ls_created_at` datetime NOT NULL,
  `ls_updated_by` int(11) NOT NULL,
  `ls_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `livestock_death_quantity`
--

CREATE TABLE `livestock_death_quantity` (
  `ld_id` int(11) NOT NULL,
  `ld_sh_id` int(11) NOT NULL,
  `ld_batch_id` int(11) NOT NULL,
  `ld_lshs_id` int(11) NOT NULL,
  `ld_purv_purs_id` int(11) NOT NULL,
  `ld_purv_ls_id` int(11) NOT NULL,
  `ld_purv_lst_id` int(11) NOT NULL,
  `ld_death_quantity` double NOT NULL,
  `ld_death_date` date NOT NULL,
  `ld_death_reason` varchar(500) NOT NULL,
  `ld_status` int(11) NOT NULL,
  `ld_created_by` int(11) NOT NULL,
  `ld_created_at` datetime NOT NULL,
  `ld_updated_by` int(11) NOT NULL,
  `ld_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `livestock_purchase_summary`
--

CREATE TABLE `livestock_purchase_summary` (
  `purs_id` int(11) NOT NULL,
  `purs_bill_no` int(11) NOT NULL,
  `purs_supp_id` int(11) NOT NULL,
  `purs_date` date NOT NULL,
  `purs_sub_total` double NOT NULL,
  `purs_grand_discount` double NOT NULL,
  `purs_grand_total` double NOT NULL,
  `purs_note` varchar(1000) NOT NULL,
  `purs_status` int(11) NOT NULL,
  `purs_created_by` int(11) NOT NULL,
  `purs_created_at` datetime NOT NULL,
  `purs_updated_by` int(11) NOT NULL,
  `purs_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `livestock_purchase_value`
--

CREATE TABLE `livestock_purchase_value` (
  `purv_id` int(11) NOT NULL,
  `purv_purs_id` int(11) NOT NULL,
  `purv_ls_id` int(11) NOT NULL,
  `purv_lst_id` int(11) NOT NULL,
  `purv_unit_price` double NOT NULL,
  `purv_quantity` double NOT NULL,
  `purv_discount` double NOT NULL,
  `purv_total` double NOT NULL,
  `purv_status` int(11) NOT NULL,
  `purv_created_by` int(11) NOT NULL,
  `purv_created_at` datetime NOT NULL,
  `purv_updated_by` int(11) NOT NULL,
  `purv_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `livestock_reproduction`
--

CREATE TABLE `livestock_reproduction` (
  `lrp_id` int(11) NOT NULL,
  `lrp_batch_id` int(11) NOT NULL,
  `lrp_sh_id` int(11) NOT NULL,
  `lrp_ls_id` int(11) NOT NULL,
  `lrp_lst_id` int(11) NOT NULL,
  `lrp_birth_quantity` double NOT NULL,
  `lrp_approx_selling_price` double NOT NULL,
  `lrp_birth_date` date NOT NULL,
  `lrp_description` varchar(500) NOT NULL,
  `lrp_status` int(11) NOT NULL,
  `lrp_created_by` int(11) NOT NULL,
  `lrp_created_at` datetime NOT NULL,
  `lrp_updated_by` int(11) NOT NULL,
  `lrp_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `livestock_sale_summary`
--

CREATE TABLE `livestock_sale_summary` (
  `lsss_id` int(11) NOT NULL,
  `lsss_c_id` int(11) NOT NULL,
  `lsss_date` date NOT NULL,
  `lsss_sub_total` double NOT NULL,
  `lsss_grand_discount` double NOT NULL,
  `lsss_grand_total` double NOT NULL,
  `lsss_note` varchar(1000) NOT NULL,
  `lsss_status` int(11) NOT NULL,
  `lsss_created_by` int(11) NOT NULL,
  `lsss_created_at` datetime NOT NULL,
  `lsss_updated_by` int(11) NOT NULL,
  `lsss_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `livestock_sale_value`
--

CREATE TABLE `livestock_sale_value` (
  `lssv_id` int(11) NOT NULL,
  `lssv_lsss_id` int(11) NOT NULL,
  `lssv_batch_id` int(11) NOT NULL,
  `lssv_shed_id` int(11) NOT NULL,
  `lssv_ls_id` int(11) NOT NULL,
  `lssv_lst_id` int(11) NOT NULL,
  `lssv_unit_price` double NOT NULL,
  `lssv_quantity` double NOT NULL,
  `lssv_discount` double NOT NULL,
  `lssv_total` double NOT NULL,
  `lssv_status` int(11) NOT NULL,
  `lssv_created_by` int(11) NOT NULL,
  `lssv_created_at` datetime NOT NULL,
  `lssv_updated_by` int(11) NOT NULL,
  `lssv_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `livestock_transfer_quantity`
--

CREATE TABLE `livestock_transfer_quantity` (
  `ltr_id` int(11) NOT NULL,
  `ltr_sh_id` int(11) NOT NULL,
  `ltr_batch_id` int(11) NOT NULL,
  `ltr_target_sh_id` int(11) NOT NULL,
  `ltr_target_batch_id` int(11) NOT NULL,
  `ltr_purv_purs_id` int(11) NOT NULL,
  `ltr_purv_ls_id` int(11) NOT NULL,
  `ltr_purv_lst_id` int(11) NOT NULL,
  `ltr_transfer_date` date NOT NULL,
  `ltr_transfer_quantity` double NOT NULL,
  `ltr_description` varchar(500) NOT NULL,
  `ltr_status` int(11) NOT NULL,
  `ltr_created_by` int(11) NOT NULL,
  `ltr_created_at` datetime NOT NULL,
  `ltr_updated_by` int(11) NOT NULL,
  `ltr_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `livestock_type`
--

CREATE TABLE `livestock_type` (
  `lst_id` int(11) NOT NULL,
  `lst_ls_id` int(11) NOT NULL,
  `lst_title` varchar(500) NOT NULL,
  `lst_description` varchar(1000) NOT NULL,
  `lst_status` int(11) NOT NULL,
  `lst_created_by` int(11) NOT NULL,
  `lst_created_at` datetime NOT NULL,
  `lst_updated_by` int(11) NOT NULL,
  `lst_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `live_assigned_shed`
--

CREATE TABLE `live_assigned_shed` (
  `lsh_id` int(11) NOT NULL,
  `lsh_lshs_id` int(11) NOT NULL,
  `lsh_sh_id` int(11) NOT NULL,
  `lsh_batch_id` int(11) NOT NULL,
  `lsh_purs_id` int(11) NOT NULL,
  `lsh_purv_id` int(11) NOT NULL,
  `lsh_purv_ls_id` int(11) NOT NULL,
  `lsh_purv_lst_id` int(11) NOT NULL,
  `lsh_assign_quantity` double NOT NULL,
  `lsh_status` int(11) NOT NULL,
  `lsh_transfer_quantity` decimal(10,0) NOT NULL,
  `lsh_transfer_status` int(11) NOT NULL,
  `lsh_reproduction_id` int(11) NOT NULL COMMENT 'This id is from Livestock_reproduction Table. When a livestock birth then it assign to shed.',
  `lsh_created_by` int(11) NOT NULL,
  `lsh_created_at` datetime NOT NULL,
  `lsh_updated_by` int(11) NOT NULL,
  `lsh_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `live_assigned_shed_summary`
--

CREATE TABLE `live_assigned_shed_summary` (
  `lshs_id` int(11) NOT NULL,
  `lshs_sh_id` int(11) NOT NULL,
  `lshs_batch_id` int(11) NOT NULL,
  `lshs_assign_date` date NOT NULL,
  `lshs_assign_total_quantity` double NOT NULL,
  `lshs_batch_title` varchar(255) NOT NULL,
  `lshs_description` varchar(500) NOT NULL,
  `lshs_status` int(11) NOT NULL,
  `lshs_transfer_date` date NOT NULL COMMENT 'Its for transfer. If transfer one shed to another shed then use it.	',
  `lshs_transfer_status` int(11) NOT NULL COMMENT 'Its for transfer. If transfer one shed to another shed then use it.',
  `lshs_transfer_total_quantity` double NOT NULL,
  `lshs_reproduction_id` int(11) NOT NULL COMMENT 'This id is from Livestock_reproduction Table. When a livestock birth then it assign to shed.	',
  `lshs_reproduction_status` int(11) NOT NULL COMMENT 'This status is for Livestock_reproduction Table. When a livestock birth then it assign to shed.	',
  `lshs_type` int(11) NOT NULL COMMENT 'This type is for purchase assign and birth assign.\r\n1 = purchase\r\n2 = birth',
  `lshs_active_status` int(11) NOT NULL COMMENT '0 = active\r\n1 = inactive/completed',
  `lshs_created_by` int(11) NOT NULL,
  `lshs_created_at` datetime NOT NULL,
  `lshs_updated_by` int(11) NOT NULL,
  `lshs_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `login_attempts`
--

CREATE TABLE `login_attempts` (
  `id` int(11) UNSIGNED NOT NULL,
  `ip_address` varchar(15) NOT NULL,
  `login` varchar(100) NOT NULL,
  `time` int(11) UNSIGNED DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `medicine`
--

CREATE TABLE `medicine` (
  `id` int(222) NOT NULL,
  `medicine_id` varchar(222) NOT NULL,
  `duration` varchar(250) NOT NULL,
  `no` varchar(250) NOT NULL,
  `p_date` varchar(250) NOT NULL,
  `n_date` varchar(250) NOT NULL,
  `l_date` varchar(250) NOT NULL,
  `add_date` varchar(250) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `payment`
--

CREATE TABLE `payment` (
  `id` int(11) NOT NULL,
  `date` varchar(100) DEFAULT NULL,
  `sale_id` int(11) DEFAULT NULL,
  `client_id` varchar(100) NOT NULL,
  `local_sale_id` text NOT NULL,
  `return_id` int(11) DEFAULT NULL,
  `purchase_id` int(11) DEFAULT NULL,
  `supplier` varchar(100) NOT NULL,
  `reference_no` varchar(50) NOT NULL,
  `transaction_id` varchar(50) DEFAULT NULL,
  `paid_by` varchar(20) NOT NULL,
  `cheque_no` varchar(20) DEFAULT NULL,
  `cc_no` varchar(20) DEFAULT NULL,
  `cc_holder` varchar(25) DEFAULT NULL,
  `cc_month` varchar(2) DEFAULT NULL,
  `cc_year` varchar(4) DEFAULT NULL,
  `cc_type` varchar(20) DEFAULT NULL,
  `amount` varchar(100) NOT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `dollar_amount` varchar(100) NOT NULL,
  `dollar_rate` varchar(100) NOT NULL,
  `created_by` int(11) NOT NULL,
  `attachment` varchar(55) DEFAULT NULL,
  `type` varchar(20) NOT NULL,
  `note` varchar(1000) DEFAULT NULL,
  `pos_paid` decimal(25,4) DEFAULT 0.0000,
  `pos_balance` decimal(25,4) DEFAULT 0.0000,
  `approval_code` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `product`
--

CREATE TABLE `product` (
  `pr_id` int(11) NOT NULL,
  `pr_prc_id` int(11) NOT NULL,
  `pr_unit_id` int(11) NOT NULL,
  `pr_name` varchar(255) NOT NULL,
  `pr_description` varchar(500) NOT NULL,
  `pr_img_url` varchar(255) NOT NULL,
  `pr_selling_price` double NOT NULL,
  `pr_status` int(11) NOT NULL,
  `pr_created_by` int(11) NOT NULL,
  `pr_created_at` datetime NOT NULL,
  `pr_updated_by` int(11) NOT NULL,
  `pr_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `product_assign`
--

CREATE TABLE `product_assign` (
  `pra_id` int(11) NOT NULL,
  `pra_pr_id` int(11) NOT NULL,
  `pra_shed_id` int(11) NOT NULL,
  `pra_batch_id` int(11) NOT NULL,
  `pra_description` varchar(500) NOT NULL,
  `pra_status` int(11) NOT NULL,
  `pra_created_by` int(11) NOT NULL,
  `pra_created_at` datetime NOT NULL,
  `pra_updated_by` int(11) NOT NULL,
  `pra_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `product_category`
--

CREATE TABLE `product_category` (
  `prc_id` int(11) NOT NULL,
  `prc_name` varchar(255) NOT NULL,
  `prc_description` varchar(500) NOT NULL,
  `prc_status` int(11) NOT NULL,
  `prc_created_by` int(11) NOT NULL,
  `prc_created_at` datetime NOT NULL,
  `prc_updated_by` int(11) NOT NULL,
  `prc_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `product_sale_summary`
--

CREATE TABLE `product_sale_summary` (
  `prss_id` int(11) NOT NULL,
  `prss_c_id` int(11) NOT NULL,
  `prss_date` date NOT NULL,
  `prss_sub_total` double NOT NULL,
  `prss_grand_discount` double NOT NULL,
  `prss_grand_total` double NOT NULL,
  `prss_note` varchar(1000) NOT NULL,
  `prss_status` int(11) NOT NULL,
  `prss_created_by` int(11) NOT NULL,
  `prss_created_at` datetime NOT NULL,
  `prss_updated_by` int(11) NOT NULL,
  `prss_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `product_sale_value`
--

CREATE TABLE `product_sale_value` (
  `prsv_id` int(11) NOT NULL,
  `prsv_prss_id` int(11) NOT NULL,
  `prsv_pra_id` int(11) NOT NULL,
  `prsv_product_id` int(11) NOT NULL,
  `prsv_unit_price` double NOT NULL,
  `prsv_quantity` double NOT NULL,
  `prsv_discount` double NOT NULL,
  `prsv_total` double NOT NULL,
  `prsv_status` int(11) NOT NULL,
  `prsv_created_by` int(11) NOT NULL,
  `prsv_created_at` datetime NOT NULL,
  `prsv_updated_by` int(11) NOT NULL,
  `prsv_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `product_stock`
--

CREATE TABLE `product_stock` (
  `prs_id` int(11) NOT NULL,
  `prs_pr_id` int(11) NOT NULL,
  `prs_pra_id` int(11) NOT NULL,
  `prs_shed_id` int(11) NOT NULL,
  `prs_batch_id` int(11) NOT NULL,
  `prs_production_quantity` double NOT NULL,
  `prs_description` varchar(500) NOT NULL,
  `prs_date` date NOT NULL,
  `prs_status` int(11) NOT NULL,
  `prs_created_by` int(11) NOT NULL,
  `prs_created_at` datetime NOT NULL,
  `prs_updated_by` int(11) NOT NULL,
  `prs_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `product_wasted`
--

CREATE TABLE `product_wasted` (
  `prw_id` int(11) NOT NULL,
  `prw_pr_id` int(11) NOT NULL,
  `prw_pra_id` int(11) NOT NULL,
  `prw_shed_id` int(11) NOT NULL,
  `prw_batch_id` int(11) NOT NULL,
  `prw_wasted_quantity` double NOT NULL,
  `prw_description` varchar(500) NOT NULL,
  `prw_date` date NOT NULL,
  `prw_status` int(11) NOT NULL,
  `prw_created_by` int(11) NOT NULL,
  `prw_created_at` datetime NOT NULL,
  `prw_updated_by` int(11) NOT NULL,
  `prw_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `purchase`
--

CREATE TABLE `purchase` (
  `id` int(100) NOT NULL,
  `reference` varchar(100) NOT NULL,
  `product` varchar(100) NOT NULL,
  `supplier` varchar(100) NOT NULL,
  `date` varchar(100) NOT NULL,
  `unit_price` varchar(100) NOT NULL,
  `quantity` varchar(100) NOT NULL,
  `discount` varchar(100) NOT NULL,
  `amount_payable` decimal(65,2) NOT NULL,
  `paid_amount` varchar(100) NOT NULL,
  `payment_status` varchar(100) NOT NULL,
  `purchase_status` int(100) NOT NULL,
  `note` varchar(1000) NOT NULL,
  `x` varchar(100) NOT NULL,
  `status` varchar(100) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `sale`
--

CREATE TABLE `sale` (
  `id` int(10) NOT NULL,
  `reference` varchar(100) NOT NULL,
  `category` varchar(100) NOT NULL,
  `category_name` varchar(100) NOT NULL,
  `type` varchar(100) NOT NULL,
  `client_id` varchar(100) NOT NULL,
  `sale_status` varchar(100) NOT NULL,
  `date` varchar(100) NOT NULL,
  `amount` varchar(100) NOT NULL,
  `vat` varchar(100) NOT NULL DEFAULT '0',
  `flat_vat` varchar(100) NOT NULL,
  `discount` varchar(100) NOT NULL DEFAULT '0',
  `flat_discount` varchar(100) NOT NULL,
  `gross_total` varchar(100) NOT NULL,
  `amount_received` varchar(100) NOT NULL,
  `balance` varchar(100) NOT NULL,
  `payment_status` varchar(100) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `settings`
--

CREATE TABLE `settings` (
  `id` int(10) NOT NULL,
  `system_vendor` varchar(100) NOT NULL,
  `title` varchar(100) NOT NULL,
  `address` varchar(100) NOT NULL,
  `phone` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `facebook_id` varchar(100) NOT NULL,
  `currency` varchar(100) NOT NULL,
  `unit` varchar(100) NOT NULL,
  `discount` varchar(100) NOT NULL,
  `vat` varchar(100) NOT NULL,
  `date_format` varchar(100) NOT NULL,
  `login_title` varchar(100) NOT NULL,
  `codec_username` varchar(100) NOT NULL,
  `codec_purchase_code` varchar(100) NOT NULL,
  `language` varchar(250) NOT NULL,
  `img_url` varchar(256) NOT NULL,
  `toggle_status` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `settings`
--

INSERT INTO `settings` (`id`, `system_vendor`, `title`, `address`, `phone`, `email`, `facebook_id`, `currency`, `unit`, `discount`, `vat`, `date_format`, `login_title`, `codec_username`, `codec_purchase_code`, `language`, `img_url`, `toggle_status`) VALUES
(1, 'Livestock - Chicken Farm Management System', 'LIVESTOCK', 'katra allahabad', '+254712351185', 'admin@example.com', '#', '$', 'pc', '0', 'percentage', 'd-m-Y', 'Live Stock - Chicken Farm Management System', '', '', 'english', 'uploads/logo11.png', 1);

-- --------------------------------------------------------

--
-- Table structure for table `shed`
--

CREATE TABLE `shed` (
  `sh_id` int(11) NOT NULL,
  `sh_no` varchar(255) NOT NULL,
  `sh_title` varchar(255) NOT NULL,
  `sh_type` varchar(255) NOT NULL,
  `sh_date` date NOT NULL,
  `sh_description` varchar(1000) NOT NULL,
  `sh_status` int(11) NOT NULL,
  `sh_created_by` int(11) NOT NULL,
  `sh_created_at` datetime NOT NULL,
  `sh_updated_by` int(11) NOT NULL,
  `sh_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `staff`
--

CREATE TABLE `staff` (
  `sf_id` int(11) NOT NULL,
  `sf_sft_id` int(11) NOT NULL,
  `sf_name` varchar(255) NOT NULL,
  `sf_email` varchar(255) NOT NULL,
  `sf_address` varchar(500) NOT NULL,
  `sf_phone` varchar(255) NOT NULL,
  `sf_description` varchar(500) NOT NULL,
  `sf_img_url` varchar(255) NOT NULL,
  `sf_status` int(11) NOT NULL,
  `sf_created_by` int(11) NOT NULL,
  `sf_created_at` datetime NOT NULL,
  `sf_updated_by` int(11) NOT NULL,
  `sf_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `staff_payment`
--

CREATE TABLE `staff_payment` (
  `sfp_id` int(11) NOT NULL,
  `sfp_sf_id` int(11) NOT NULL,
  `sfp_received_amount` double NOT NULL,
  `sfp_payment_amount` double NOT NULL,
  `sfp_paid_by` varchar(255) NOT NULL,
  `sfp_cheque_no` varchar(255) NOT NULL,
  `sfp_reference` varchar(255) NOT NULL,
  `sfp_date` date NOT NULL,
  `sfp_description` varchar(255) NOT NULL,
  `sfp_status` int(11) NOT NULL,
  `sfp_created_by` int(11) NOT NULL,
  `sfp_created_at` datetime NOT NULL,
  `sfp_updated_by` int(11) NOT NULL,
  `sfp_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `staff_type`
--

CREATE TABLE `staff_type` (
  `sft_id` int(11) NOT NULL,
  `sft_name` varchar(255) NOT NULL,
  `sft_description` varchar(500) NOT NULL,
  `sft_status` int(11) NOT NULL,
  `sft_created_by` int(11) NOT NULL,
  `sft_created_at` datetime NOT NULL,
  `sft_updated_by` int(11) NOT NULL,
  `sft_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `supplier`
--

CREATE TABLE `supplier` (
  `s_id` int(11) NOT NULL,
  `s_st_id` int(11) NOT NULL,
  `s_name` varchar(255) NOT NULL,
  `s_email` varchar(255) NOT NULL,
  `s_address` varchar(500) NOT NULL,
  `s_phone` varchar(255) NOT NULL,
  `s_description` varchar(500) NOT NULL,
  `s_img_url` varchar(255) NOT NULL,
  `s_status` int(11) NOT NULL,
  `s_created_by` int(11) NOT NULL,
  `s_created_at` datetime NOT NULL,
  `s_updated_by` int(11) NOT NULL,
  `s_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `supplier_payment`
--

CREATE TABLE `supplier_payment` (
  `sp_id` int(11) NOT NULL,
  `sp_s_id` int(11) NOT NULL,
  `sp_purs_id` int(11) NOT NULL,
  `sp_fdps_id` int(11) NOT NULL,
  `sp_vps_id` int(11) NOT NULL,
  `sp_payment_amount` double NOT NULL,
  `sp_paid_by` varchar(255) NOT NULL,
  `sp_cheque_no` varchar(255) NOT NULL,
  `sp_reference` varchar(255) NOT NULL,
  `sp_date` date NOT NULL,
  `sp_description` varchar(255) NOT NULL,
  `sp_status` int(11) NOT NULL,
  `sp_purchase_type` int(11) NOT NULL COMMENT '1 = Livestock purchase paid amount, \r\n2 = food purchase paid amount, \r\n3 = vaccine purchase paid amount',
  `sp_created_by` int(11) NOT NULL,
  `sp_created_at` datetime NOT NULL,
  `sp_updated_by` int(11) NOT NULL,
  `sp_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `supplier_type`
--

CREATE TABLE `supplier_type` (
  `st_id` int(11) NOT NULL,
  `st_name` varchar(255) NOT NULL,
  `st_description` varchar(500) NOT NULL,
  `st_status` int(11) NOT NULL,
  `st_created_by` int(11) NOT NULL,
  `st_created_at` datetime NOT NULL,
  `st_updated_by` int(11) NOT NULL,
  `st_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `unit`
--

CREATE TABLE `unit` (
  `un_id` int(11) NOT NULL,
  `un_name` varchar(255) NOT NULL,
  `un_description` varchar(500) NOT NULL,
  `un_status` int(11) NOT NULL,
  `un_created_by` int(11) NOT NULL,
  `un_created_at` datetime NOT NULL,
  `un_updated_by` int(11) NOT NULL,
  `un_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` int(11) UNSIGNED NOT NULL,
  `ip_address` varchar(15) NOT NULL,
  `username` varchar(100) NOT NULL,
  `password` varchar(255) NOT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `email` varchar(100) NOT NULL,
  `activation_code` varchar(40) DEFAULT NULL,
  `forgotten_password_code` varchar(40) DEFAULT NULL,
  `forgotten_password_time` int(11) UNSIGNED DEFAULT NULL,
  `remember_code` varchar(40) DEFAULT NULL,
  `created_on` int(11) UNSIGNED NOT NULL,
  `last_login` int(11) UNSIGNED DEFAULT NULL,
  `active` tinyint(1) UNSIGNED DEFAULT NULL,
  `first_name` varchar(50) DEFAULT NULL,
  `last_name` varchar(50) DEFAULT NULL,
  `company` varchar(100) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `ip_address`, `username`, `password`, `salt`, `email`, `activation_code`, `forgotten_password_code`, `forgotten_password_time`, `remember_code`, `created_on`, `last_login`, `active`, `first_name`, `last_name`, `company`, `phone`) VALUES
(1, '127.0.0.1', 'Admin', '$2y$08$g1u0qcMP1wTgxK0yyho4xuc5EdtJwuCD8ETe6OQQWkAQmbFBA.DQ.', 'NULL', 'admin@example.com', 'NULL', 'wTvWME9FIkBM3h8t1St41O225d1010c68b1aed53', 1674545202, NULL, 1268889823, 1689413489, 1, 'Admin', 'istrator', 'ADMIN', '0'),
(244, '103.231.163.30', 'Mr Client', '$2y$08$AZVlco3jHL3LH2MyOKe59O7hcmakwE0Wgwp5pu5KZdSTxbvLFMe.2', NULL, 'client@example.com', NULL, NULL, NULL, NULL, 1442014065, 1510985852, 1, NULL, NULL, NULL, NULL),
(246, '110.76.129.222', 'fsdfsdf', '$2y$08$RPFDGLN.q6/WcRA0pOz7NudhXmFsVe8vrYV/rdt.WrbbNjnyWT6wG', NULL, 'fsdfsdf', NULL, NULL, NULL, NULL, 1507121290, NULL, 1, NULL, NULL, NULL, NULL),
(247, '118.67.223.106', 'tyutyuyi', '$2y$08$eQPrpQxpl3zZDpq.gziAUOagrghqhEmBWKuaIlwblAOcU869Z4RKq', NULL, 'tyuyiyui@.com', NULL, NULL, NULL, NULL, 1508135227, NULL, 1, NULL, NULL, NULL, NULL),
(248, '118.67.223.106', 'dddddd', '$2y$08$vhohdo2iHbGEjTpFOw7ImeiQB/WA4p3lEanxYOKMFng677.RhkKRu', NULL, 'dddddd', NULL, NULL, NULL, NULL, 1508932770, NULL, 1, NULL, NULL, NULL, NULL),
(249, '103.26.246.170', 'ggg', '$2y$08$dk9f25OIfW44FSPDJOmfKus2Pcc0eIZvZ.5068Nb.NXJ5DG/WTThO', NULL, 'kjkjhjj@hhh', NULL, NULL, NULL, NULL, 1509450300, NULL, 1, NULL, NULL, NULL, NULL),
(250, '103.26.246.170', 'dddd', '$2y$08$PQIGJwoGgSJmd4zk6a9sUO0iP5adDDybCfhqlABz7zKxkNTm.acxy', NULL, 'ddd@gg', NULL, NULL, NULL, NULL, 1509451031, NULL, 1, NULL, NULL, NULL, NULL),
(251, '103.26.246.170', 'wwwww', '$2y$08$e/XNombowDssScpaU1sc5.8E0gJa24efQdVbPcGtfoNO6JRceyeLS', NULL, 'ww@gmail.com', NULL, NULL, NULL, NULL, 1509777416, NULL, 1, NULL, NULL, NULL, NULL),
(252, '103.26.246.170', 'opu', '$2y$08$6qeavNT1HjeJpw8jfBAVzOirmLd58qSdizO5Gg2.mTQ9zuGw2Dasm', NULL, 'jjjj@ggh', NULL, NULL, NULL, NULL, 1509778258, NULL, 1, NULL, NULL, NULL, NULL),
(253, '103.26.246.170', 'ddd', '$2y$08$jlaGemAoQSWL4mByq4TKruWWsFeywepCiQ2d3oWWp0duyuS/E0bb.', NULL, 'll@lll', NULL, NULL, NULL, NULL, 1509778311, NULL, 1, NULL, NULL, NULL, NULL),
(254, '103.26.246.170', 'hfduih', '$2y$08$Txl/s1JTC2TD/4J3q2Ae2urbBlYqCXjO/rlXi21BKbzn8rPE.Ca0C', NULL, 'dfdf@gfg', NULL, NULL, NULL, NULL, 1509779534, NULL, 1, NULL, NULL, NULL, NULL),
(255, '103.26.246.170', 'fghfgf', '$2y$08$S8Fc92uhKjOymqjRQxirZeZpI71u3egLsr/gEKFdcPlJU.Rw16m9C', NULL, 'rimonhoshen@gmail.com', NULL, NULL, NULL, NULL, 1509781167, NULL, 1, NULL, NULL, NULL, NULL),
(256, '103.231.162.58', 'bsvsnvnvbnbvnbv', '$2y$08$3yWGstY8MAWmn6w/flv7c.LYcDiRMqUtkzm2SPyVairVyhdNoqB4i', NULL, 'nbvnbvnbvn@jhbjhg.com', NULL, NULL, NULL, NULL, 1510034923, NULL, 1, NULL, NULL, NULL, NULL),
(257, '103.26.246.170', 'Rahim', '$2y$08$2BJY1hU6NBF9rC.55LM1ZuTMsTYDhtFTx8yG7GIAMeYjWNtR.y9hi', NULL, 'rahim@gmail.com', NULL, NULL, NULL, NULL, 1510405457, 1510985791, 1, NULL, NULL, NULL, NULL),
(258, '103.26.246.170', 'Karim', '$2y$08$MYtGDNHM/wpoJHECx7jhyus4WmZEkIMEGnv4AC5IvRDPoRPgKBfuu', NULL, 'karim@gmail.com', NULL, 'NgYlBxOz-GucW87T5wudmO2a7831c6d252886220', 1653191203, NULL, 1510405508, NULL, 1, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `users_groups`
--

CREATE TABLE `users_groups` (
  `id` int(11) UNSIGNED NOT NULL,
  `user_id` int(11) UNSIGNED NOT NULL,
  `group_id` mediumint(8) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `users_groups`
--

INSERT INTO `users_groups` (`id`, `user_id`, `group_id`) VALUES
(1, 1, 1),
(2, 1, 2),
(246, 244, 5),
(248, 246, 5),
(249, 247, 5),
(250, 248, 5),
(251, 249, 4),
(252, 250, 4),
(253, 251, 5),
(254, 252, 5),
(255, 253, 5),
(256, 254, 4),
(257, 255, 4),
(258, 256, 4),
(259, 257, 4),
(260, 258, 4);

-- --------------------------------------------------------

--
-- Table structure for table `vaccination`
--

CREATE TABLE `vaccination` (
  `vccn_id` int(11) NOT NULL,
  `vccn_vcc_id` int(11) NOT NULL,
  `vccn_ls_id` int(11) NOT NULL,
  `vccn_lst_id` int(11) NOT NULL,
  `vccn_status` int(11) NOT NULL,
  `vccn_created_by` int(11) NOT NULL,
  `vccn_created_at` datetime NOT NULL,
  `vccn_updated_by` int(11) NOT NULL,
  `vccn_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `vaccine`
--

CREATE TABLE `vaccine` (
  `vcc_id` int(11) NOT NULL,
  `vcc_vaccine_id` int(11) NOT NULL,
  `vcc_name` varchar(255) NOT NULL,
  `vcc_unit_id` int(11) NOT NULL,
  `vcc_description` varchar(255) NOT NULL,
  `vcc_status` int(11) NOT NULL,
  `vcc_created_by` int(11) NOT NULL,
  `vcc_created_at` datetime NOT NULL,
  `vcc_updated_by` int(11) NOT NULL,
  `vcc_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `vaccine_dose_assigned_quantity`
--

CREATE TABLE `vaccine_dose_assigned_quantity` (
  `vdq_id` int(11) NOT NULL,
  `vdq_vccn_id` int(11) NOT NULL,
  `vdq_dose_serial` int(11) NOT NULL,
  `vdq_vcc_id` int(11) NOT NULL,
  `vdq_vaccination_date` double NOT NULL,
  `vdq_vaccine_route` int(11) NOT NULL,
  `vdq_description` varchar(500) NOT NULL,
  `vdq_status` int(11) NOT NULL,
  `vdq_created_by` int(11) NOT NULL,
  `vdq_created_at` datetime NOT NULL,
  `vdq_updated_by` int(11) NOT NULL,
  `vdq_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `vaccine_dose_status`
--

CREATE TABLE `vaccine_dose_status` (
  `vds_id` int(11) NOT NULL,
  `vds_vdq_id` int(11) NOT NULL,
  `vds_vcc_id` int(11) NOT NULL,
  `vds_vccn_id` int(11) NOT NULL,
  `vds_batch_id` int(11) NOT NULL,
  `vds_lshs_id` int(11) NOT NULL,
  `vds_sh_id` int(11) NOT NULL,
  `vds_status` int(11) NOT NULL,
  `vds_created_by` int(11) NOT NULL,
  `vds_created_at` datetime NOT NULL,
  `vds_updated_by` int(11) NOT NULL,
  `vds_updated_at` datetime NOT NULL,
  `vds_vaccine_used_quantity` double NOT NULL,
  `vds_description` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `vaccine_purchase_summary`
--

CREATE TABLE `vaccine_purchase_summary` (
  `vps_id` int(11) NOT NULL,
  `vps_s_id` int(11) NOT NULL,
  `vps_date` date NOT NULL,
  `vps_sub_total` double NOT NULL,
  `vps_grand_discount` double NOT NULL,
  `vps_grand_total` double NOT NULL,
  `vps_description` varchar(500) NOT NULL,
  `vps_status` int(11) NOT NULL,
  `vps_created_by` int(11) NOT NULL,
  `vps_created_at` datetime NOT NULL,
  `vps_updated_by` int(11) NOT NULL,
  `vps_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `vaccine_purchase_value`
--

CREATE TABLE `vaccine_purchase_value` (
  `vpv_id` int(11) NOT NULL,
  `vpv_vps_id` int(11) NOT NULL,
  `vpv_vcc_id` int(11) NOT NULL,
  `vpv_unit_price` double NOT NULL,
  `vpv_quantity` double NOT NULL,
  `vpv_discount` double NOT NULL,
  `vpv_total` double NOT NULL,
  `vpv_status` int(11) NOT NULL,
  `vpv_created_by` int(11) NOT NULL,
  `vpv_created_at` datetime NOT NULL,
  `vpv_updated_by` int(11) NOT NULL,
  `vpv_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `vaccine_route`
--

CREATE TABLE `vaccine_route` (
  `vccr_id` int(11) NOT NULL,
  `vccr_name` varchar(255) NOT NULL,
  `vccr_description` varchar(500) NOT NULL,
  `vccr_status` int(11) NOT NULL,
  `vccr_created_by` int(11) NOT NULL,
  `vccr_created_at` datetime NOT NULL,
  `vccr_updated_by` int(11) NOT NULL,
  `vccr_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `vaccine_used`
--

CREATE TABLE `vaccine_used` (
  `vccu_id` int(11) NOT NULL,
  `vccu_vcc_id` int(11) NOT NULL,
  `vccu_used_quantity` double NOT NULL,
  `vccu_description` varchar(255) NOT NULL,
  `vccu_status` int(11) NOT NULL,
  `vccu_created_by` int(11) NOT NULL,
  `vccu_created_at` datetime NOT NULL,
  `vccu_updated_by` int(11) NOT NULL,
  `vccu_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `vaccine_wasted`
--

CREATE TABLE `vaccine_wasted` (
  `vccw_id` int(11) NOT NULL,
  `vccw_vcc_id` int(11) NOT NULL,
  `vccw_quantity` double NOT NULL,
  `vccw_description` varchar(500) NOT NULL,
  `vccw_status` int(11) NOT NULL,
  `vccw_created_by` int(11) NOT NULL,
  `vccw_created_at` datetime NOT NULL,
  `vccw_updated_by` int(11) NOT NULL,
  `vccw_updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Indexes for dumped tables
--

--
-- Indexes for table `client`
--
ALTER TABLE `client`
  ADD PRIMARY KEY (`c_id`);

--
-- Indexes for table `client_payment`
--
ALTER TABLE `client_payment`
  ADD PRIMARY KEY (`cp_id`);

--
-- Indexes for table `client_type`
--
ALTER TABLE `client_type`
  ADD PRIMARY KEY (`ct_id`);

--
-- Indexes for table `expense`
--
ALTER TABLE `expense`
  ADD PRIMARY KEY (`ex_id`);

--
-- Indexes for table `expense_category`
--
ALTER TABLE `expense_category`
  ADD PRIMARY KEY (`exc_id`);

--
-- Indexes for table `expense_payment`
--
ALTER TABLE `expense_payment`
  ADD PRIMARY KEY (`exp_id`);

--
-- Indexes for table `expense_subcategory`
--
ALTER TABLE `expense_subcategory`
  ADD PRIMARY KEY (`exsc_id`);

--
-- Indexes for table `food_distributed_summary`
--
ALTER TABLE `food_distributed_summary`
  ADD PRIMARY KEY (`fdds_id`);

--
-- Indexes for table `food_distributed_value`
--
ALTER TABLE `food_distributed_value`
  ADD PRIMARY KEY (`fddv_id`);

--
-- Indexes for table `food_purchase_summary`
--
ALTER TABLE `food_purchase_summary`
  ADD PRIMARY KEY (`fdps_id`);

--
-- Indexes for table `food_purchase_value`
--
ALTER TABLE `food_purchase_value`
  ADD PRIMARY KEY (`fdpv_id`);

--
-- Indexes for table `food_summary`
--
ALTER TABLE `food_summary`
  ADD PRIMARY KEY (`fds_id`);

--
-- Indexes for table `food_value`
--
ALTER TABLE `food_value`
  ADD PRIMARY KEY (`fdv_id`);

--
-- Indexes for table `food_wasted`
--
ALTER TABLE `food_wasted`
  ADD PRIMARY KEY (`fdw_id`);

--
-- Indexes for table `groups`
--
ALTER TABLE `groups`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `livestock`
--
ALTER TABLE `livestock`
  ADD PRIMARY KEY (`ls_id`);

--
-- Indexes for table `livestock_death_quantity`
--
ALTER TABLE `livestock_death_quantity`
  ADD PRIMARY KEY (`ld_id`);

--
-- Indexes for table `livestock_purchase_summary`
--
ALTER TABLE `livestock_purchase_summary`
  ADD PRIMARY KEY (`purs_id`);

--
-- Indexes for table `livestock_purchase_value`
--
ALTER TABLE `livestock_purchase_value`
  ADD PRIMARY KEY (`purv_id`);

--
-- Indexes for table `livestock_reproduction`
--
ALTER TABLE `livestock_reproduction`
  ADD PRIMARY KEY (`lrp_id`);

--
-- Indexes for table `livestock_sale_summary`
--
ALTER TABLE `livestock_sale_summary`
  ADD PRIMARY KEY (`lsss_id`);

--
-- Indexes for table `livestock_sale_value`
--
ALTER TABLE `livestock_sale_value`
  ADD PRIMARY KEY (`lssv_id`);

--
-- Indexes for table `livestock_transfer_quantity`
--
ALTER TABLE `livestock_transfer_quantity`
  ADD PRIMARY KEY (`ltr_id`);

--
-- Indexes for table `livestock_type`
--
ALTER TABLE `livestock_type`
  ADD PRIMARY KEY (`lst_id`);

--
-- Indexes for table `live_assigned_shed`
--
ALTER TABLE `live_assigned_shed`
  ADD PRIMARY KEY (`lsh_id`);

--
-- Indexes for table `live_assigned_shed_summary`
--
ALTER TABLE `live_assigned_shed_summary`
  ADD PRIMARY KEY (`lshs_id`);

--
-- Indexes for table `login_attempts`
--
ALTER TABLE `login_attempts`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `medicine`
--
ALTER TABLE `medicine`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `product`
--
ALTER TABLE `product`
  ADD PRIMARY KEY (`pr_id`);

--
-- Indexes for table `product_assign`
--
ALTER TABLE `product_assign`
  ADD PRIMARY KEY (`pra_id`);

--
-- Indexes for table `product_category`
--
ALTER TABLE `product_category`
  ADD PRIMARY KEY (`prc_id`);

--
-- Indexes for table `product_sale_summary`
--
ALTER TABLE `product_sale_summary`
  ADD PRIMARY KEY (`prss_id`);

--
-- Indexes for table `product_sale_value`
--
ALTER TABLE `product_sale_value`
  ADD PRIMARY KEY (`prsv_id`);

--
-- Indexes for table `product_stock`
--
ALTER TABLE `product_stock`
  ADD PRIMARY KEY (`prs_id`);

--
-- Indexes for table `product_wasted`
--
ALTER TABLE `product_wasted`
  ADD PRIMARY KEY (`prw_id`);

--
-- Indexes for table `purchase`
--
ALTER TABLE `purchase`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `sale`
--
ALTER TABLE `sale`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `settings`
--
ALTER TABLE `settings`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `shed`
--
ALTER TABLE `shed`
  ADD PRIMARY KEY (`sh_id`);

--
-- Indexes for table `staff`
--
ALTER TABLE `staff`
  ADD PRIMARY KEY (`sf_id`);

--
-- Indexes for table `staff_payment`
--
ALTER TABLE `staff_payment`
  ADD PRIMARY KEY (`sfp_id`);

--
-- Indexes for table `staff_type`
--
ALTER TABLE `staff_type`
  ADD PRIMARY KEY (`sft_id`);

--
-- Indexes for table `supplier`
--
ALTER TABLE `supplier`
  ADD PRIMARY KEY (`s_id`);

--
-- Indexes for table `supplier_payment`
--
ALTER TABLE `supplier_payment`
  ADD PRIMARY KEY (`sp_id`);

--
-- Indexes for table `supplier_type`
--
ALTER TABLE `supplier_type`
  ADD PRIMARY KEY (`st_id`);

--
-- Indexes for table `unit`
--
ALTER TABLE `unit`
  ADD PRIMARY KEY (`un_id`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `users_groups`
--
ALTER TABLE `users_groups`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uc_users_groups` (`user_id`,`group_id`),
  ADD KEY `fk_users_groups_users1_idx` (`user_id`),
  ADD KEY `fk_users_groups_groups1_idx` (`group_id`);

--
-- Indexes for table `vaccination`
--
ALTER TABLE `vaccination`
  ADD PRIMARY KEY (`vccn_id`);

--
-- Indexes for table `vaccine`
--
ALTER TABLE `vaccine`
  ADD PRIMARY KEY (`vcc_id`);

--
-- Indexes for table `vaccine_dose_assigned_quantity`
--
ALTER TABLE `vaccine_dose_assigned_quantity`
  ADD PRIMARY KEY (`vdq_id`);

--
-- Indexes for table `vaccine_dose_status`
--
ALTER TABLE `vaccine_dose_status`
  ADD PRIMARY KEY (`vds_id`);

--
-- Indexes for table `vaccine_purchase_summary`
--
ALTER TABLE `vaccine_purchase_summary`
  ADD PRIMARY KEY (`vps_id`);

--
-- Indexes for table `vaccine_purchase_value`
--
ALTER TABLE `vaccine_purchase_value`
  ADD PRIMARY KEY (`vpv_id`);

--
-- Indexes for table `vaccine_route`
--
ALTER TABLE `vaccine_route`
  ADD PRIMARY KEY (`vccr_id`);

--
-- Indexes for table `vaccine_used`
--
ALTER TABLE `vaccine_used`
  ADD PRIMARY KEY (`vccu_id`);

--
-- Indexes for table `vaccine_wasted`
--
ALTER TABLE `vaccine_wasted`
  ADD PRIMARY KEY (`vccw_id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `client`
--
ALTER TABLE `client`
  MODIFY `c_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `client_payment`
--
ALTER TABLE `client_payment`
  MODIFY `cp_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `client_type`
--
ALTER TABLE `client_type`
  MODIFY `ct_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `expense`
--
ALTER TABLE `expense`
  MODIFY `ex_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `expense_category`
--
ALTER TABLE `expense_category`
  MODIFY `exc_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `expense_payment`
--
ALTER TABLE `expense_payment`
  MODIFY `exp_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `expense_subcategory`
--
ALTER TABLE `expense_subcategory`
  MODIFY `exsc_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `food_distributed_summary`
--
ALTER TABLE `food_distributed_summary`
  MODIFY `fdds_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `food_distributed_value`
--
ALTER TABLE `food_distributed_value`
  MODIFY `fddv_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `food_purchase_summary`
--
ALTER TABLE `food_purchase_summary`
  MODIFY `fdps_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `food_purchase_value`
--
ALTER TABLE `food_purchase_value`
  MODIFY `fdpv_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `food_summary`
--
ALTER TABLE `food_summary`
  MODIFY `fds_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `food_value`
--
ALTER TABLE `food_value`
  MODIFY `fdv_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `food_wasted`
--
ALTER TABLE `food_wasted`
  MODIFY `fdw_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `groups`
--
ALTER TABLE `groups`
  MODIFY `id` mediumint(8) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `livestock`
--
ALTER TABLE `livestock`
  MODIFY `ls_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `livestock_death_quantity`
--
ALTER TABLE `livestock_death_quantity`
  MODIFY `ld_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `livestock_purchase_summary`
--
ALTER TABLE `livestock_purchase_summary`
  MODIFY `purs_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `livestock_purchase_value`
--
ALTER TABLE `livestock_purchase_value`
  MODIFY `purv_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `livestock_reproduction`
--
ALTER TABLE `livestock_reproduction`
  MODIFY `lrp_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `livestock_sale_summary`
--
ALTER TABLE `livestock_sale_summary`
  MODIFY `lsss_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `livestock_sale_value`
--
ALTER TABLE `livestock_sale_value`
  MODIFY `lssv_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `livestock_transfer_quantity`
--
ALTER TABLE `livestock_transfer_quantity`
  MODIFY `ltr_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `livestock_type`
--
ALTER TABLE `livestock_type`
  MODIFY `lst_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `live_assigned_shed`
--
ALTER TABLE `live_assigned_shed`
  MODIFY `lsh_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `live_assigned_shed_summary`
--
ALTER TABLE `live_assigned_shed_summary`
  MODIFY `lshs_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `login_attempts`
--
ALTER TABLE `login_attempts`
  MODIFY `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `medicine`
--
ALTER TABLE `medicine`
  MODIFY `id` int(222) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `product`
--
ALTER TABLE `product`
  MODIFY `pr_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `product_assign`
--
ALTER TABLE `product_assign`
  MODIFY `pra_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `product_category`
--
ALTER TABLE `product_category`
  MODIFY `prc_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `product_sale_summary`
--
ALTER TABLE `product_sale_summary`
  MODIFY `prss_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `product_sale_value`
--
ALTER TABLE `product_sale_value`
  MODIFY `prsv_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `product_stock`
--
ALTER TABLE `product_stock`
  MODIFY `prs_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `product_wasted`
--
ALTER TABLE `product_wasted`
  MODIFY `prw_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `purchase`
--
ALTER TABLE `purchase`
  MODIFY `id` int(100) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `sale`
--
ALTER TABLE `sale`
  MODIFY `id` int(10) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `settings`
--
ALTER TABLE `settings`
  MODIFY `id` int(10) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `shed`
--
ALTER TABLE `shed`
  MODIFY `sh_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `staff`
--
ALTER TABLE `staff`
  MODIFY `sf_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `staff_payment`
--
ALTER TABLE `staff_payment`
  MODIFY `sfp_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `staff_type`
--
ALTER TABLE `staff_type`
  MODIFY `sft_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `supplier`
--
ALTER TABLE `supplier`
  MODIFY `s_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `supplier_payment`
--
ALTER TABLE `supplier_payment`
  MODIFY `sp_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `supplier_type`
--
ALTER TABLE `supplier_type`
  MODIFY `st_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `unit`
--
ALTER TABLE `unit`
  MODIFY `un_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users`
  MODIFY `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=259;

--
-- AUTO_INCREMENT for table `users_groups`
--
ALTER TABLE `users_groups`
  MODIFY `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=261;

--
-- AUTO_INCREMENT for table `vaccination`
--
ALTER TABLE `vaccination`
  MODIFY `vccn_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `vaccine`
--
ALTER TABLE `vaccine`
  MODIFY `vcc_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `vaccine_dose_assigned_quantity`
--
ALTER TABLE `vaccine_dose_assigned_quantity`
  MODIFY `vdq_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `vaccine_dose_status`
--
ALTER TABLE `vaccine_dose_status`
  MODIFY `vds_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `vaccine_purchase_summary`
--
ALTER TABLE `vaccine_purchase_summary`
  MODIFY `vps_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `vaccine_purchase_value`
--
ALTER TABLE `vaccine_purchase_value`
  MODIFY `vpv_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `vaccine_route`
--
ALTER TABLE `vaccine_route`
  MODIFY `vccr_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `vaccine_used`
--
ALTER TABLE `vaccine_used`
  MODIFY `vccu_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `vaccine_wasted`
--
ALTER TABLE `vaccine_wasted`
  MODIFY `vccw_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `users_groups`
--
ALTER TABLE `users_groups`
  ADD CONSTRAINT `fk_users_groups_groups1` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_users_groups_users1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
