<!--sidebar end-->
<!--main content start-->
<section id="main-content">
    <section class="wrapper site-min-height">
        <!-- page start-->
        <div class="col-md-12">
            <section class="panel">
                <header class="panel-heading">
                    <i class="fas fa-stream"></i> <?= lang('livestock_sale_list'); ?>
                </header>

                <div class="panel-body">
                    <div class="adv-table editable-table ">
                        <div class="clearfix new">
                            <a href="<?php echo base_url('') ?>sale/addNewSale">
                                <div class="btn-group">
                                    <button id="" class="button button-primary">
                                        <i class="fas fa-plus-circle"></i> <?php echo lang('add_new_sale'); ?>
                                    </button>
                                </div>
                            </a>
                            <button class="export" onclick="javascript:window.print();"><i class="fa-solid fa-print"></i> <?php echo lang('print'); ?></button>
                        </div>
                        <div class="space15">
                            <div class="row">
                                <div class="col-lg-3 col-md-6 col-sm-6">
                                    <div class="new__cards card__box">
                                        <div class="col-xs-8">
                                            <p><?= lang('total_livestock'); ?> (<?= $settings->unit; ?>)</p>
                                            <h3><?php $totalAssignedQuantity = $this->purchase_model->getTotalLivestockAssignedToShedQuantity();
                                                if ($totalAssignedQuantity) {
                                                    echo $totalAssignedQuantity;
                                                } else {
                                                    echo 0;
                                                }
                                                ?></h3>
                                        </div>
                                        <div class="col-xs-4">
                                            <div class="text-right">
                                                <ul class="social__icon">
                                                    <li class="icon">
                                                        <span><i class="fa-solid fa-store"></i></span>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-6 col-sm-6">
                                    <div class="new__cards card__box">
                                        <div class="col-xs-8">
                                            <p><?= lang('total_sold_quantity'); ?> (<?= $settings->unit; ?>): <strong><?php $totalSaleQuantity = $this->sale_model->getTotalSaleLivestockQuantity();
                                                                                                                        if ($totalSaleQuantity) {
                                                                                                                            echo $totalSaleQuantity;
                                                                                                                        } else {
                                                                                                                            echo 0;
                                                                                                                        }
                                                                                                                        ?></strong></p>
                                            <p><?= lang('total_death'); ?> (<?= $settings->unit; ?>): <strong><?php $totalDeathQuantity = $this->shed_model->getTotalDeathLivestock();
                                                                                                                if ($totalDeathQuantity) {
                                                                                                                    echo $totalDeathQuantity;
                                                                                                                } else {
                                                                                                                    echo 0;
                                                                                                                }
                                                                                                                ?></strong></p>
                                        </div>
                                        <div class="col-xs-4">
                                            <div class="text-right">
                                                <ul class="social__icon">
                                                    <li class="icon">
                                                        <span><i class="fa-solid fa-cart-shopping"></i></span>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-6 col-sm-6">
                                    <div class="new__cards card__box">
                                        <div class="col-xs-8">
                                            <p><?= lang('stock_in_shed'); ?> (<?= $settings->unit; ?>)</p>
                                            <h3><?php
                                                $stockQuantity = $totalAssignedQuantity - ($totalSaleQuantity + $totalDeathQuantity);
                                                if ($stockQuantity) {
                                                    echo $stockQuantity;
                                                } else {
                                                    echo 0;
                                                }
                                                ?></h3>
                                        </div>
                                        <div class="col-xs-4">
                                            <div class="text-right">
                                                <ul class="social__icon">
                                                    <li class="icon">
                                                        <span><i class="fa-solid fa-store-slash"></i></span>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-6 col-sm-6">
                                    <div class="new__cards card__box">
                                        <div class="col-xs-8">
                                            <p><?= lang('total_sold_amount'); ?></p>
                                            <h3><?php $totalSaleAmount = $this->sale_model->getTotalLivestockSaleAmount();
                                                if ($totalSaleAmount) {
                                                    echo $settings->currency . number_format($totalSaleAmount, 2, ".", ",");
                                                } else {
                                                    echo 0;
                                                }
                                                ?>
                                            </h3>
                                        </div>
                                        <div class="col-xs-4">
                                            <div class="text-right">
                                                <ul class="social__icon">
                                                    <li class="icon">
                                                        <span><i class="fa-solid fa-money-bill"></i></span>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <table class="table table-striped table-hover table-bordered" id="editable-sample">
                            <thead>
                                <tr>
                                    <th> <?php echo lang('serialNo'); ?> </th>
                                    <th> <?= lang('sold'); ?> <?= lang('date'); ?> </th>
                                    <th> <?= lang('client'); ?> </th>
                                    <th> <?= lang('total_livestock_sold'); ?> (<?= $settings->unit ?>)</th>
                                    <th> <?= lang('total_sold_amount'); ?> (<?php echo lang('amount'); ?>)</th>
                                    <th class="option_th"><?php echo lang('options'); ?> </th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $serial = 0;
                                foreach ($getLivestockSales as $sales) {
                                    $serial++;
                                ?>
                                    <tr class="">
                                        <td> <?= $serial; ?> </td>
                                        <td> <?= date("$settings->date_format", strtotime($sales->lsss_date)); ?> </td>
                                        <td> <?= $this->client_model->getClientById($sales->lsss_c_id)->c_name; ?> </td>
                                        <td> <?= $this->sale_model->getTotalLivestockSumBySaleSummaryId($sales->lsss_id) ?> </td>
                                        <td> <?= $settings->currency; ?><?= number_format($sales->lsss_grand_total, 2, '.', ','); ?> </td>
                                        <td class="option" style="width: 30%;">
                                            <?php if ($this->ion_auth->in_group('admin')) { ?>
                                                <a class="button button-info" href="<?php echo base_url('') ?>sale/viewLivestockSale?lsss_id=<?php echo $sales->lsss_id; ?>"><i class="fa-solid fa-file-invoice"></i> <?= lang('invoice_capital'); ?></a>
                                                <a class="button button-warning" href="<?php echo base_url('') ?>sale/editLivestockSale?lsss_id=<?php echo $sales->lsss_id; ?>"><i class="fas fa-edit"></i> <?php echo lang('edit'); ?></a>
                                                <a class="button button-danger" href="<?php echo base_url('') ?>sale/deleteLivestockSale?lsss_id=<?php echo $sales->lsss_id; ?>" onclick="return confirm('<?= lang('are_you_sure_want_to_delete_this_item'); ?>')"><i class="fas fa-trash"></i> <?php echo lang('delete'); ?></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>

                </div>
            </section>
        </div>
        <!-- page end-->
    </section>
</section>
<!--main content end-->
<!--footer start-->


<script src="<?php echo base_url('common/js/jquery-1.11.1.min.js'); ?>"></script>
<script>
    $(document).ready(function() {
        $(".success_flash_message").delay(3000).fadeOut(100);
    });
</script>